/*:
 * @target MZ
 * @plugindesc 敵のHPバーを表示する簡易プラグイン
 * @author ChatGPT
 */

(() => {
  const _Sprite_Enemy_initialize = Sprite_Enemy.prototype.initialize;
  Sprite_Enemy.prototype.initialize = function(battler) {
    _Sprite_Enemy_initialize.call(this, battler);
    this._hpBar = new Sprite();
    this._hpBar.bitmap = new Bitmap(64, 8);
    this._hpBar.y = -10; // HPバーの表示位置を調整
    this.addChild(this._hpBar);
  };

  const _Sprite_Enemy_update = Sprite_Enemy.prototype.update;
  Sprite_Enemy.prototype.update = function() {
    _Sprite_Enemy_update.call(this);
    this.updateHpBar();
  };

  Sprite_Enemy.prototype.updateHpBar = function() {
    const rate = this._battler.hpRate();
    const width = 64;
    const height = 8;
    const color1 = "#ffa07a";
    const color2 = "#000000";

    this._hpBar.bitmap.clear();
    this._hpBar.bitmap.fillRect(0, 0, width, height, color2); // 背景
    this._hpBar.bitmap.fillRect(0, 0, width * rate, height, color1); // 現在HP
  };
})();
